/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LarcenyTriggeredAbility
extends TriggeredAbilityImpl {
    public LarcenyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1), false);
    }

    private LarcenyTriggeredAbility(LarcenyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LarcenyTriggeredAbility copy() {
        return new LarcenyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature;
        if (((DamagedPlayerEvent)event).isCombatDamage() && (creature = game.getPermanent(event.getSourceId())) != null && creature.isControlledBy(this.controllerId)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control deals combat damage to a player, that player discards a card.";
    }
}

