/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;

class LastStandEffect
extends OneShotEffect {
    private static final FilterControlledLandPermanent filterSwamp = new FilterControlledLandPermanent();
    private static final FilterControlledLandPermanent filterMountain = new FilterControlledLandPermanent();
    private static final FilterControlledLandPermanent filterPlains = new FilterControlledLandPermanent();
    private static final FilterControlledLandPermanent filterForest = new FilterControlledLandPermanent();
    private static final FilterControlledLandPermanent filterIsland = new FilterControlledLandPermanent();

    public LastStandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent loses 2 life for each Swamp you control. {this} deals damage to target creature equal to the number of Mountains you control. Create a 1/1 green Saproling creature token for each Forest you control. You gain 2 life for each Plains you control. Draw a card for each Island you control, then discard that many cards";
    }

    private LastStandEffect(LastStandEffect effect) {
        super((OneShotEffect)effect);
    }

    public LastStandEffect copy() {
        return new LastStandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int forests;
            int mountains;
            Permanent creature;
            Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (opponent != null) {
                int swamps = game.getBattlefield().count((FilterPermanent)filterSwamp, source.getControllerId(), source, game);
                opponent.loseLife(swamps * 2, game, source, false);
            }
            if ((creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null && (mountains = game.getBattlefield().count((FilterPermanent)filterMountain, source.getControllerId(), source, game)) > 0) {
                creature.damage(mountains, source.getSourceId(), source, game, false, true);
            }
            if ((forests = game.getBattlefield().count((FilterPermanent)filterForest, source.getControllerId(), source, game)) > 0) {
                new CreateTokenEffect((Token)new SaprolingToken(), forests).apply(game, source);
            }
            int plains = game.getBattlefield().count((FilterPermanent)filterPlains, source.getControllerId(), source, game);
            controller.gainLife(plains * 2, game, source);
            int islands = game.getBattlefield().count((FilterPermanent)filterIsland, source.getControllerId(), source, game);
            if (islands > 0) {
                controller.drawCards(islands, source, game);
                controller.discard(islands, false, false, source, game);
            }
        }
        return false;
    }

    static {
        filterSwamp.add((Predicate)SubType.SWAMP.getPredicate());
        filterMountain.add((Predicate)SubType.MOUNTAIN.getPredicate());
        filterPlains.add((Predicate)SubType.PLAINS.getPredicate());
        filterForest.add((Predicate)SubType.FOREST.getPredicate());
        filterIsland.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

