/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class LatNamsLegacyEffect
extends OneShotEffect {
    LatNamsLegacyEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Shuffle a card from your hand into your library. If you do, draw two cards at the beginning of the next turn's upkeep";
    }

    private LatNamsLegacyEffect(LatNamsLegacyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getHand().isEmpty()) {
            TargetCard target = new TargetCard(Zone.HAND, new FilterCard("card to shuffle into your library"));
            controller.choose(Outcome.Detriment, controller.getHand(), target, source, game);
            Card card = controller.getHand().get(target.getFirstTarget(), game);
            if (card != null) {
                boolean successful = controller.moveCards(card, Zone.LIBRARY, source, game);
                controller.shuffleLibrary(source, game);
                if (successful) {
                    new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new AtTheBeginOfNextUpkeepDelayedTriggeredAbility((Effect)new DrawCardSourceControllerEffect(2)), false).apply(game, source);
                }
            }
            return true;
        }
        return true;
    }

    public LatNamsLegacyEffect copy() {
        return new LatNamsLegacyEffect(this);
    }
}

