/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LavalancheEffect
extends OneShotEffect {
    private DynamicValue amount;

    public LavalancheEffect(DynamicValue amount) {
        super(Outcome.Damage);
        this.amount = amount;
        this.staticText = "{this} deals X damage to target player or planeswalker and each creature that player or that planeswalker's controller controls";
    }

    private LavalancheEffect(LavalancheEffect effect) {
        super((OneShotEffect)effect);
        this.amount = effect.amount;
    }

    public LavalancheEffect copy() {
        return new LavalancheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        targetPlayer.damage(this.amount.calculate(game, source, (Effect)this), source.getSourceId(), source, game);
        FilterPermanent filter = new FilterPermanent("and each creature that player or that planeswalker's controller controls");
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
        List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        for (Permanent permanent : permanents) {
            permanent.damage(this.amount.calculate(game, source, (Effect)this), source.getSourceId(), source, game, false, true);
        }
        return true;
    }
}

