/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LaviniaAzoriusRenegadeReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    LaviniaAzoriusRenegadeReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Each opponent can't cast noncreature spells with mana value greater than the number of lands that player controls.";
    }

    private LaviniaAzoriusRenegadeReplacementEffect(LaviniaAzoriusRenegadeReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast noncreature spells with mana value greater than " + this.getLandCount(source, event, game) + " (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getPlayer(source.getControllerId()).hasOpponent(event.getPlayerId(), game)) {
            FilterCard filter = new FilterCard();
            filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, this.getLandCount(source, event, game)));
            Card card = game.getCard(event.getSourceId());
            return card != null && filter.match(card, game);
        }
        return false;
    }

    private int getLandCount(Ability source, GameEvent event, Game game) {
        int landCount = 0;
        UUID playerId = event.getPlayerId();
        if (playerId != null) {
            List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, playerId, source, game);
            for (Permanent permanent : permanents) {
                if (!permanent.isControlledBy(playerId)) continue;
                ++landCount;
            }
        }
        return landCount;
    }

    public LaviniaAzoriusRenegadeReplacementEffect copy() {
        return new LaviniaAzoriusRenegadeReplacementEffect(this);
    }
}

