/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.common.OneOrMoreDamagePlayerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class LaylaHassanTriggeredAbility
extends OneOrMoreDamagePlayerTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Assassins");

    public LaylaHassanTriggeredAbility(Effect effect) {
        super(effect, (FilterPermanent)filter, true, true);
    }

    private LaylaHassanTriggeredAbility(LaylaHassanTriggeredAbility ability) {
        super((OneOrMoreDamagePlayerTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER) {
            return super.checkTrigger(event, game);
        }
        return false;
    }

    public String getRule() {
        return "When {this} enters the battlefield and whenever one or more Assassins you control deal combat damage to a player, return target historic card from your graveyard to your hand.";
    }

    public LaylaHassanTriggeredAbility copy() {
        return new LaylaHassanTriggeredAbility(this);
    }

    static {
        filter.add((Predicate)SubType.ASSASSIN.getPredicate());
    }
}

