/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class LazavFamiliarStrangerEffect
extends OneShotEffect {
    LazavFamiliarStrangerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Then you may exile a card from a graveyard. If a creature card was exiled this way, you may have {this} become a copy of that card until end of turn.";
    }

    private LazavFamiliarStrangerEffect(LazavFamiliarStrangerEffect effect) {
        super((OneShotEffect)effect);
    }

    public LazavFamiliarStrangerEffect copy() {
        return new LazavFamiliarStrangerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        boolean flag = card.isCreature(game);
        player.moveCards(card, Zone.EXILED, source, game);
        if (!flag) {
            return true;
        }
        Permanent lazav = source.getSourcePermanentIfItStillExists(game);
        if (lazav == null) {
            return true;
        }
        if (player.chooseUse(Outcome.PutCreatureInPlay, "Do you want " + lazav.getLogName() + " to become a copy of " + card.getLogName() + " until end of turn?", source, game)) {
            game.copyPermanent(Duration.EndOfTurn, (Permanent)new PermanentCard(card, source.getControllerId(), game), source.getSourceId(), source, null);
        }
        return true;
    }
}

