/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LeafCrownedElderPlayEffect
extends OneShotEffect {
    LeafCrownedElderPlayEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may play that card without paying its mana cost";
    }

    private LeafCrownedElderPlayEffect(LeafCrownedElderPlayEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && card != null) {
            if (controller.chooseUse(Outcome.PlayForFree, "Play " + card.getIdName() + " without paying its mana cost?", source, game)) {
                controller.playCard(card, game, true, new ApprovingObject(source, game));
            }
            return true;
        }
        return false;
    }

    public LeafCrownedElderPlayEffect copy() {
        return new LeafCrownedElderPlayEffect(this);
    }
}

