/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class LedevChampionEffect
extends OneShotEffect {
    public LedevChampionEffect() {
        super(Outcome.GainLife);
        this.staticText = "you may tap any number of untapped creatures you control. {this} gets +1/+1 until end of turn for each creature tapped this way.";
    }

    private LedevChampionEffect(LedevChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURES, true);
        target.choose(Outcome.Tap, source.getControllerId(), source.getSourceId(), source, game);
        int tappedAmount = 0;
        for (UUID creatureId : target.getTargets()) {
            Permanent creature = game.getPermanent(creatureId);
            if (creature == null) continue;
            creature.tap(source, game);
            ++tappedAmount;
        }
        if (tappedAmount > 0) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(tappedAmount, tappedAmount, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }

    public LedevChampionEffect copy() {
        return new LedevChampionEffect(this);
    }
}

