/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class LeechesEffect
extends OneShotEffect {
    LeechesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player loses all poison counters. {this} deals that much damage to that player";
    }

    private LeechesEffect(LeechesEffect effect) {
        super((OneShotEffect)effect);
    }

    public LeechesEffect copy() {
        return new LeechesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        int countPoisonCounters = targetPlayer.getCountersCount(CounterType.POISON);
        if (countPoisonCounters > 0) {
            targetPlayer.loseAllCounters(CounterType.POISON.getName(), source, game);
            targetPlayer.damage(countPoisonCounters, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

