/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class LegateLaniusCaesarsAceSacrificeEffect
extends OneShotEffect {
    LegateLaniusCaesarsAceSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each opponent sacrifices a tenth of the creatures they control, rounded up.";
    }

    private LegateLaniusCaesarsAceSacrificeEffect(LegateLaniusCaesarsAceSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegateLaniusCaesarsAceSacrificeEffect copy() {
        return new LegateLaniusCaesarsAceSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet perms = new HashSet();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            int num = (game.getBattlefield().count((FilterPermanent)filter, playerId, source, game) + 9) / 10;
            int numTargets = Math.min(num, game.getBattlefield().count(TargetSacrifice.makeFilter((FilterPermanent)filter), playerId, source, game));
            if (numTargets < 1) continue;
            TargetSacrifice target = new TargetSacrifice(numTargets, (FilterPermanent)filter);
            while (!target.isChosen(game) && target.canChoose(playerId, source, game) && player.canRespond()) {
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
            }
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

