/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class LegionLoyalistCantBeBlockedByTokensEffect
extends RestrictionEffect {
    LegionLoyalistCantBeBlockedByTokensEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "and can't be blocked by creature tokens this turn";
    }

    private LegionLoyalistCantBeBlockedByTokensEffect(LegionLoyalistCantBeBlockedByTokensEffect effect) {
        super((RestrictionEffect)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.setAffectedObjectsSet(true);
        for (Permanent perm : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, source.getControllerId(), source, game)) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
        }
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.affectedObjectList.contains(new MageObjectReference((MageObject)permanent, game));
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return !(blocker instanceof PermanentToken);
    }

    public LegionLoyalistCantBeBlockedByTokensEffect copy() {
        return new LegionLoyalistCantBeBlockedByTokensEffect(this);
    }
}

