/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class LegionsInitiativeReturnFromExileEffect
extends OneShotEffect {
    LegionsInitiativeReturnFromExileEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return those cards to the battlefield under their owner's control and those creatures gain haste until end of turn";
    }

    private LegionsInitiativeReturnFromExileEffect(LegionsInitiativeReturnFromExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegionsInitiativeReturnFromExileEffect copy() {
        return new LegionsInitiativeReturnFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (controller == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)exileZone);
        controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        List permanents = cards.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        return true;
    }
}

