/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Map;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class LeoninArbiterCantSearchEffect
extends ContinuousRuleModifyingEffectImpl {
    private final String keyString;

    public LeoninArbiterCantSearchEffect(String keyString) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't search libraries.";
        this.keyString = keyString;
    }

    private LeoninArbiterCantSearchEffect(LeoninArbiterCantSearchEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.keyString = effect.keyString;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.SEARCH_LIBRARY == event.getType();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            long turnNum;
            long zoneChangeCount;
            Long activationState;
            boolean applies = true;
            String key = permanent.getId() + this.keyString;
            Map.Entry turnIgnoringPlayersPair = (Map.Entry)game.getState().getValue(key);
            if (turnIgnoringPlayersPair != null && (activationState = Long.valueOf((zoneChangeCount = (long)permanent.getZoneChangeCounter(game)) << 32 | (turnNum = (long)game.getTurnNum()) & 0xFFFFFFFFL)).equals(turnIgnoringPlayersPair.getKey())) {
                applies = !((Set)turnIgnoringPlayersPair.getValue()).contains(event.getPlayerId());
            }
            return applies;
        }
        return false;
    }

    public LeoninArbiterCantSearchEffect copy() {
        return new LeoninArbiterCantSearchEffect(this);
    }
}

