/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Iterator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class LethalStingCost
extends CostImpl {
    public LethalStingCost() {
        this.text = "put a -1/-1 counter on a creature you control";
    }

    private LethalStingCost(LethalStingCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Iterator iterator = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controllerId, game).iterator();
        if (iterator.hasNext()) {
            Permanent permanent = (Permanent)iterator.next();
            return permanent != null;
        }
        return false;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller != null) {
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            controller.chooseTarget(Outcome.UnboostCreature, (Target)target, ability, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.addCounters(CounterType.M1M1.createInstance(), controllerId, ability, game);
                game.informPlayers(controller.getLogName() + " puts a -1/-1 counter on " + permanent.getLogName());
                this.paid = true;
            }
        }
        return this.paid;
    }

    public LethalStingCost copy() {
        return new LethalStingCost(this);
    }
}

