/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.game.Game;

class LethalThrowdownEffect
extends OneShotEffect {
    LethalThrowdownEffect() {
        super(Outcome.Benefit);
        this.staticText = "If the modified creature was sacrificed, draw a card";
    }

    private LethalThrowdownEffect(LethalThrowdownEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost cost : source.getCosts()) {
            OrCost orCost;
            if (!(cost instanceof OrCost) || !(orCost = (OrCost)cost).getSelectedCost().getText().equals("sacrifice a modified creature")) continue;
            return new DrawCardSourceControllerEffect(1).apply(game, source);
        }
        return false;
    }

    public LethalThrowdownEffect copy() {
        return new LethalThrowdownEffect(this);
    }
}

