/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class LevelerExileLibraryEffect
extends OneShotEffect {
    LevelerExileLibraryEffect() {
        super(Outcome.Exile);
        this.staticText = "exile all cards from your library";
    }

    private LevelerExileLibraryEffect(LevelerExileLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int count = controller.getLibrary().size();
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, count));
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }

    public LevelerExileLibraryEffect copy() {
        return new LevelerExileLibraryEffect(this);
    }
}

