/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class LeviathanCostToAttackBlockEffect
extends PayCostToAttackBlockEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Islands");

    LeviathanCostToAttackBlockEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK, (Cost)new SacrificeTargetCost(2, (FilterPermanent)filter));
        this.staticText = "{this} can't attack unless you sacrifice two Islands. <i>(This cost is paid as attackers are declared.)</i>";
    }

    private LeviathanCostToAttackBlockEffect(LeviathanCostToAttackBlockEffect effect) {
        super((PayCostToAttackBlockEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getSourceId());
    }

    public LeviathanCostToAttackBlockEffect copy() {
        return new LeviathanCostToAttackBlockEffect(this);
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

