/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LeyLineEffect
extends OneShotEffect {
    LeyLineEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "that player may put a +1/+1 counter on target creature of their choice";
    }

    private LeyLineEffect(LeyLineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        if (player.chooseUse(Outcome.BoostCreature, "Put a +1/+1 counter on " + permanent.getName() + "?", source, game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), player.getId(), source, game);
        }
        return true;
    }

    public LeyLineEffect copy() {
        return new LeyLineEffect(this);
    }
}

