/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LeylineOfTheGuildpactEffect
extends ContinuousEffectImpl {
    private static final ObjectColor allColors = new ObjectColor("WUBRG");

    LeylineOfTheGuildpactEffect() {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "each nonland permanent you control is all colors";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private LeylineOfTheGuildpactEffect(LeylineOfTheGuildpactEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LeylineOfTheGuildpactEffect copy() {
        return new LeylineOfTheGuildpactEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND, source.getControllerId(), source, game)) {
            permanent.getColor(game).addColor(allColors);
        }
        return true;
    }
}

