/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LiabilityEffect
extends OneShotEffect {
    LiabilityEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player loses 1 life.";
    }

    private LiabilityEffect(LiabilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public LiabilityEffect copy() {
        return new LiabilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        if (permanent != null && (controller = game.getPlayer(permanent.getControllerId())) != null) {
            controller.loseLife(1, game, source, false);
            return true;
        }
        return false;
    }
}

