/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetSacrifice;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class LichKnightsConquestEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("artifacts, enchantments, and/or tokens");

    LichKnightsConquestEffect() {
        super(Outcome.Benefit);
        this.staticText = "Sacrifice any number of artifacts, enchantments, and/or tokens. Return that many creature cards from your graveyard to the battlefield.";
    }

    private LichKnightsConquestEffect(LichKnightsConquestEffect effect) {
        super((OneShotEffect)effect);
    }

    public LichKnightsConquestEffect copy() {
        return new LichKnightsConquestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        controller.chooseTarget(Outcome.Sacrifice, (Target)target, source, game);
        List toSacrifice = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!toSacrifice.isEmpty()) {
            int sacrificeCount = toSacrifice.size();
            game.informPlayers(controller.getLogName() + " chose " + sacrificeCount + " permanents to sacrifice. " + CardUtil.getSourceLogName((Game)game, (Ability)source));
            new SacrificeTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(toSacrifice, game)).apply(game, source);
            game.processAction();
            int cardsToMove = Math.min(sacrificeCount, controller.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD, game));
            target = new TargetCardInYourGraveyard(cardsToMove, cardsToMove, (FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
            if (!target.canChoose(source.getControllerId(), source, game)) {
                return true;
            }
            controller.chooseTarget(Outcome.PutCreatureInPlay, (Target)target, source, game);
            CardsImpl cards = new CardsImpl();
            cards.addAll((Collection)target.getTargets());
            controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.ENCHANTMENT.getPredicate(), TokenPredicate.TRUE}));
    }
}

