/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedLifeLossValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetControlledPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LichsMasteryLoseLifeEffect
extends OneShotEffect {
    LichsMasteryLoseLifeEffect() {
        super(Outcome.Exile);
        this.staticText = "for each 1 life you lost, exile a permanent you control or a card from your hand or graveyard";
    }

    private LichsMasteryLoseLifeEffect(LichsMasteryLoseLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LichsMasteryLoseLifeEffect copy() {
        return new LichsMasteryLoseLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent();
        filter.add((Predicate)new ControllerIdPredicate(controller.getId()));
        for (int i = 0; i < SavedLifeLossValue.MANY.calculate(game, source, (Effect)this); ++i) {
            Card card;
            TargetControlledPermanent target;
            int handCount = controller.getHand().size();
            int graveCount = controller.getGraveyard().size();
            int permCount = game.getBattlefield().getActivePermanents(filter, controller.getId(), game).size();
            if (graveCount + handCount == 0 || permCount > 0 && controller.chooseUse(Outcome.Exile, "Exile permanent you control? (No = from hand or graveyard)", source, game)) {
                target = new TargetControlledPermanent(1, 1, new FilterControlledPermanent(), true);
                controller.choose(this.outcome, (Target)target, source, game);
                ExileTargetEffect effect = new ExileTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
                effect.apply(game, source);
                continue;
            }
            if (graveCount == 0 || handCount > 0 && controller.chooseUse(Outcome.Exile, "Exile a card from your hand? (No = from graveyard)", source, game)) {
                target = new TargetCardInHand(1, 1, new FilterCard());
                controller.choose(this.outcome, (Target)target, source, game);
                card = controller.getHand().get(target.getFirstTarget(), game);
                if (card == null) continue;
                controller.moveCards(card, Zone.EXILED, source, game);
                continue;
            }
            target = new TargetCardInYourGraveyard(1, 1, new FilterCard(), true);
            target.choose(Outcome.Exile, source.getControllerId(), source.getSourceId(), source, game);
            card = controller.getGraveyard().get(target.getFirstTarget(), game);
            if (card == null) continue;
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        return true;
    }
}

