/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class LieInWaitTargetEffect
extends OneShotEffect {
    LieInWaitTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature card from your graveyard to your hand. {this} deals damage equal to that card's power to target creature";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private LieInWaitTargetEffect(LieInWaitTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public LieInWaitTargetEffect copy() {
        return new LieInWaitTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List targets = this.getTargetPointer().getTargets(game, source);
        Card card = game.getCard((UUID)targets.get(0));
        if (card == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean result = card.moveToZone(Zone.HAND, source, game, false);
        if (result && targets.size() >= 2) {
            int power = card.getPower().getValue();
            Permanent permanent = game.getPermanent((UUID)targets.get(1));
            permanent.damage(power, source, game);
        }
        return result;
    }
}

