/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SquirrelToken;
import mage.players.Player;
import mage.util.ManaUtil;

class LiegeOfTheHollowsEffect
extends OneShotEffect {
    LiegeOfTheHollowsEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player may pay any amount of mana. Then each player creates a number of 1/1 green Squirrel creature tokens equal to the amount of mana they paid this way";
    }

    private LiegeOfTheHollowsEffect(LiegeOfTheHollowsEffect effect) {
        super((OneShotEffect)effect);
    }

    public LiegeOfTheHollowsEffect copy() {
        return new LiegeOfTheHollowsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, Integer> paidMana = new HashMap<UUID, Integer>();
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                paidMana.put(player.getId(), ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Liege of the Hollows", (Player)player, (Ability)source, (Game)game));
            }
            SquirrelToken token = new SquirrelToken();
            for (Map.Entry entry : paidMana.entrySet()) {
                Player player = game.getPlayer((UUID)entry.getKey());
                if (player == null) continue;
                token.putOntoBattlefield(((Integer)entry.getValue()).intValue(), game, source, player.getId());
            }
            game.processAction();
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

