/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.SpellCastAllTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SetTargetPointer;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.watchers.common.CommanderPlaysCountWatcher;

public final class LiesaShroudOfDusk
extends CardImpl {
    public LiesaShroudOfDusk(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}{W}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.ANGEL);
        this.power = new MageInt(5);
        this.toughness = new MageInt(5);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new InfoEffect("Rather than pay {2} for each previous time you've cast this spell from the command zone this game, pay 2 life that many times.")));
        this.addAbility((Ability)FlyingAbility.getInstance());
        this.addAbility((Ability)LifelinkAbility.getInstance());
        this.addAbility((Ability)new SpellCastAllTriggeredAbility((Effect)new LoseLifeTargetEffect(2).setText("they lose 2 life"), StaticFilters.FILTER_SPELL_A, false, SetTargetPointer.PLAYER));
    }

    private LiesaShroudOfDusk(LiesaShroudOfDusk card) {
        super((CardImpl)card);
    }

    public LiesaShroudOfDusk copy() {
        return new LiesaShroudOfDusk(this);
    }

    public boolean commanderCost(Game game, Ability source, Ability abilityToModify) {
        CommanderPlaysCountWatcher watcher = (CommanderPlaysCountWatcher)game.getState().getWatcher(CommanderPlaysCountWatcher.class);
        int castCount = watcher.getPlaysCount(this.getMainCard().getId());
        if (castCount > 0) {
            abilityToModify.addCost((Cost)new PayLifeCost(2 * castCount));
        }
        return true;
    }
}

