/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SoldierToken;

class LieutenantsOfTheGuardEffect
extends OneShotEffect {
    LieutenantsOfTheGuardEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for strength or numbers. Put a +1/+1 counter on {this} for each strength vote and create a 1/1 white Soldier creature token for each numbers vote.";
    }

    private LieutenantsOfTheGuardEffect(LieutenantsOfTheGuardEffect effect) {
        super((OneShotEffect)effect);
    }

    public LieutenantsOfTheGuardEffect copy() {
        return new LieutenantsOfTheGuardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Strength (+1/+1 counter)", "Numbers (1/1 token)", Outcome.Benefit);
        vote.doVotes(source, game);
        int strengthCount = vote.getVoteCount((Object)true);
        int numbersCount = vote.getVoteCount((Object)false);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (strengthCount > 0 && permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(strengthCount), source.getControllerId(), source, game);
        }
        if (numbersCount > 0) {
            new SoldierToken().putOntoBattlefield(numbersCount, game, source, source.getControllerId());
        }
        return strengthCount + numbersCount > 0;
    }
}

