/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LifecraftEngineAddSubTypeAllEffect
extends ContinuousEffectImpl {
    static FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public LifecraftEngineAddSubTypeAllEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Vehicle creatures you control are the chosen creature type in addition to their other types.";
    }

    private LifecraftEngineAddSubTypeAllEffect(LifecraftEngineAddSubTypeAllEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LifecraftEngineAddSubTypeAllEffect copy() {
        return new LifecraftEngineAddSubTypeAllEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (controller == null || subType == null) {
            return false;
        }
        List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, controllerId, game);
        for (Permanent creature : creatures) {
            if (creature == null) continue;
            creature.addSubType(game, new SubType[]{subType});
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.VEHICLE.getPredicate());
    }
}

