/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LifesLegacyEffect
extends OneShotEffect {
    LifesLegacyEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw cards equal to the sacrificed creature's power";
    }

    private LifesLegacyEffect(LifesLegacyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int power = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
            power = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getPower().getValue();
            break;
        }
        if (power > 0) {
            controller.drawCards(power, source, game);
        }
        return true;
    }

    public LifesLegacyEffect copy() {
        return new LifesLegacyEffect(this);
    }
}

