/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashMap;
import java.util.Map;
import mage.MageInt;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class LifestreamsBlessingWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> map = new HashMap<MageObjectReference, Integer>();

    LifestreamsBlessingWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null) {
            return;
        }
        this.map.put(new MageObjectReference(spell.getSpellAbility().getSourceId(), game), game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, spell.getControllerId(), game).stream().map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0));
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static int getValue(Game game, Ability source) {
        return ((LifestreamsBlessingWatcher)game.getState().getWatcher(LifestreamsBlessingWatcher.class)).map.getOrDefault(new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game), 0);
    }
}

