/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LightUpTheNightEffect
extends OneShotEffect {
    LightUpTheNightEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to any target. It deals X plus 1 damage instead if that target is a creature or planeswalker";
    }

    private LightUpTheNightEffect(LightUpTheNightEffect effect) {
        super((OneShotEffect)effect);
    }

    public LightUpTheNightEffect copy() {
        return new LightUpTheNightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damage = GetXValue.instance.calculate(game, source, (Effect)this);
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Player player = game.getPlayer(targetId);
        if (player != null) {
            return player.damage(damage, source.getSourceId(), source, game) > 0;
        }
        Permanent permanent = game.getPermanent(targetId);
        return permanent != null && permanent.damage(damage + (permanent.isCreature(game) || permanent.isPlaneswalker(game) ? 1 : 0), source.getSourceId(), source, game) > 0;
    }
}

