/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LightmineFieldEffect
extends OneShotEffect {
    LightmineFieldEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to each of those creatures equal to the number of attacking creatures";
    }

    private LightmineFieldEffect(LightmineFieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public LightmineFieldEffect copy() {
        return new LightmineFieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damage = game.getCombat().getAttackers().size();
        Set attackSet = (Set)this.getValue("Lightmine Field");
        if (damage > 0) {
            for (MageObjectReference attacker : attackSet) {
                Permanent creature = attacker.getPermanent(game);
                if (creature == null) continue;
                creature.damage(damage, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

