/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class LightningArmyOfOneEffect
extends ReplacementEffectImpl {
    LightningArmyOfOneEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Benefit);
        this.staticText = "until your next turn, if a source would deal damage to that player or a permanent that player controls, it deals double that damage instead";
    }

    private LightningArmyOfOneEffect(LightningArmyOfOneEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public LightningArmyOfOneEffect copy() {
        return new LightningArmyOfOneEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (targetId == null) {
            return false;
        }
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                return targetId.equals(event.getPlayerId());
            }
            case DAMAGE_PERMANENT: {
                return targetId.equals(game.getControllerId(event.getTargetId()));
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

