/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AdditionalCombatPhaseEffect;
import mage.abilities.effects.common.UntapAllControllerEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LightningRunnerEffect
extends OneShotEffect {
    LightningRunnerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you get {E}{E}, then you may pay eight {E}. If you pay, untap all creatures you control, and after this phase, there is an additional combat phase";
    }

    private LightningRunnerEffect(LightningRunnerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            new GetEnergyCountersControllerEffect(2).apply(game, source);
            if (controller.getCountersCount(CounterType.ENERGY) > 7) {
                PayEnergyCost cost = new PayEnergyCost(8);
                if (controller.chooseUse(this.outcome, "Pay eight {E} to use this? ", "Untap all creatures you control and after this phase, there is an additional combat phase.", "Yes", "No", source, game) && cost.pay(source, game, source, source.getControllerId(), true)) {
                    new UntapAllControllerEffect((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES).apply(game, source);
                    new AdditionalCombatPhaseEffect().apply(game, source);
                }
            }
            return true;
        }
        return false;
    }

    public LightningRunnerEffect copy() {
        return new LightningRunnerEffect(this);
    }
}

