/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class LilianaDeathMagePlusEffect
extends OneShotEffect {
    LilianaDeathMagePlusEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return up to one target creature card from your graveyard to your hand";
    }

    private LilianaDeathMagePlusEffect(LilianaDeathMagePlusEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaDeathMagePlusEffect copy() {
        return new LilianaDeathMagePlusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = game.getCard(((Target)source.getTargets().get(0)).getFirstTarget());
        if (card == null) {
            return false;
        }
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

