/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.abilities.effects.common.MillCardsControllerEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.continuous.AddCreatureTypeAdditionEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class LilianaDeathsMajesty
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("non-Zombie creatures");

    public LilianaDeathsMajesty(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{3}{B}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.LILIANA);
        this.setStartingLoyalty(5);
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new ZombieToken()), 1);
        ability.addEffect((Effect)new MillCardsControllerEffect(2));
        this.addAbility((Ability)ability);
        ability = new LoyaltyAbility((Effect)new AddCreatureTypeAdditionEffect(SubType.ZOMBIE, true).setText("Return target creature card"), -3);
        ability.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD));
        ability.addEffect((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect().setText(" from your graveyard to the battlefield. That creature is a black Zombie in addition to its other colors and types"));
        this.addAbility((Ability)ability);
        ability = new LoyaltyAbility((Effect)new DestroyAllEffect((FilterPermanent)filter), -7);
        this.addAbility((Ability)ability);
    }

    private LilianaDeathsMajesty(LilianaDeathsMajesty card) {
        super((CardImpl)card);
    }

    public LilianaDeathsMajesty copy() {
        return new LilianaDeathsMajesty(this);
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.ZOMBIE.getPredicate()));
    }
}

