/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;

class LilianaOfTheDarkRealmsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SWAMP);

    LilianaOfTheDarkRealmsEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target creature gets +X/+X or -X/-X until end of turn, where X is the number of Swamps you control.";
    }

    private LilianaOfTheDarkRealmsEffect(LilianaOfTheDarkRealmsEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaOfTheDarkRealmsEffect copy() {
        return new LilianaOfTheDarkRealmsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int swamps = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        if (swamps < 1) {
            return false;
        }
        String plusMessage = "+" + swamps + "/+" + swamps;
        String minusMessage = "-" + swamps + "/-" + swamps;
        if (!player.chooseUse(this.outcome, "Give " + plusMessage + " or " + minusMessage + "?", null, plusMessage, minusMessage, source, game)) {
            swamps *= -1;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(swamps, swamps, Duration.EndOfTurn), source);
        return true;
    }
}

