/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class LilypadVillageWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    LilypadVillageWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent != null && (permanent.hasSubtype(SubType.BIRD, game) || permanent.hasSubtype(SubType.FROG, game) || permanent.hasSubtype(SubType.OTTER, game) || permanent.hasSubtype(SubType.RAT, game))) {
            this.players.add(permanent.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((LilypadVillageWatcher)game.getState().getWatcher(LilypadVillageWatcher.class)).players.contains(playerId);
    }
}

