/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LimDulsVaultEffect
extends OneShotEffect {
    LimDulsVaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top five cards of your library. As many times as you choose, you may pay 1 life, put those cards on the bottom of your library in any order, then look at the top five cards of your library. Then shuffle and put the last cards you looked at this way on top in any order";
    }

    private LimDulsVaultEffect(LimDulsVaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public LimDulsVaultEffect copy() {
        return new LimDulsVaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean doAgain;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        do {
            CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
            player.lookAtCards(source, null, (Cards)cards, game);
            doAgain = player.chooseUse(this.outcome, "Pay 1 life and look at the next 5 cards?", source, game);
            if (doAgain) {
                player.loseLife(1, game, source, false);
                player.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
                continue;
            }
            player.shuffleLibrary(source, game);
            player.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
        } while (!player.isComputer() && doAgain);
        return true;
    }
}

