/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LinvalaShieldOfSeaGateEffect
extends OneShotEffect {
    LinvalaShieldOfSeaGateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose hexproof or indestructible. Creatures you control gain that ability until end of turn.";
    }

    private LinvalaShieldOfSeaGateEffect(LinvalaShieldOfSeaGateEffect effect) {
        super((OneShotEffect)effect);
    }

    public LinvalaShieldOfSeaGateEffect copy() {
        return new LinvalaShieldOfSeaGateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HexproofAbility ability = player.chooseUse(Outcome.Neutral, "Choose hexproof or indestructible", null, "Hexproof", "Indestructible", source, game) ? HexproofAbility.getInstance() : IndestructibleAbility.getInstance();
        game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)ability, Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE), source);
        return true;
    }
}

