/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class LivingArmor
extends CardImpl {
    public LivingArmor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{4}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new LivingArmorEffect(), (Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        ability.addTarget((Target)new TargetCreaturePermanent());
        this.addAbility((Ability)ability);
    }

    private LivingArmor(LivingArmor card) {
        super((CardImpl)card);
    }

    public LivingArmor copy() {
        return new LivingArmor(this);
    }

    static class LivingArmorEffect
    extends OneShotEffect {
        public LivingArmorEffect() {
            super(Outcome.BoostCreature);
            this.staticText = "Put X +0/+1 counters on target creature, where X is that creature's mana value";
        }

        private LivingArmorEffect(LivingArmorEffect effect) {
            super((OneShotEffect)effect);
        }

        public LivingArmorEffect copy() {
            return new LivingArmorEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent creature = game.getPermanent(source.getTargets().getFirstTarget());
            if (creature != null) {
                int amount = creature.getManaValue();
                creature.addCounters(CounterType.P0P1.createInstance(amount), source.getControllerId(), source, game);
                return true;
            }
            return false;
        }
    }
}

