/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class LivingBreakthroughEffect
extends ContinuousRuleModifyingEffectImpl {
    private int manaValue = -1;

    LivingBreakthroughEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Benefit);
        this.staticText = "your opponents can't cast spells with the same mana value as that spell until your next turn";
    }

    private LivingBreakthroughEffect(LivingBreakthroughEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.manaValue = effect.manaValue;
    }

    public LivingBreakthroughEffect copy() {
        return new LivingBreakthroughEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell != null) {
            this.manaValue = spell.getManaValue();
        }
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast spells with mana value " + this.manaValue + " this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.getManaValue() == this.manaValue;
    }
}

