/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class LivingInfernoEffect
extends OneShotEffect {
    LivingInfernoEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage equal to its power divided as you choose among any number of target creatures. Each of those creatures deals damage equal to its power to {this}";
    }

    private LivingInfernoEffect(LivingInfernoEffect effect) {
        super((OneShotEffect)effect);
    }

    public LivingInfernoEffect copy() {
        return new LivingInfernoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!source.getTargets().isEmpty()) {
            Target multiTarget = (Target)source.getTargets().get(0);
            HashSet<Permanent> permanents = new HashSet<Permanent>();
            for (UUID target : multiTarget.getTargets()) {
                Permanent permanent = game.getPermanent(target);
                if (permanent == null) continue;
                permanents.add(permanent);
                permanent.damage(multiTarget.getTargetAmount(target), source.getSourceId(), source, game, false, true);
            }
            Permanent sourceCreature = game.getPermanent(source.getSourceId());
            if (sourceCreature != null) {
                for (Permanent permanent : permanents) {
                    sourceCreature.damage(permanent.getPower().getValue(), permanent.getId(), source, game, false, true);
                }
            }
            return true;
        }
        return false;
    }
}

