/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LlanowarDruidEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public LlanowarDruidEffect() {
        super(Outcome.Untap);
        this.staticText = "Untap all Forests";
    }

    private LlanowarDruidEffect(LlanowarDruidEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                permanent.untap(game);
            }
            return true;
        }
        return false;
    }

    public LlanowarDruidEffect copy() {
        return new LlanowarDruidEffect(this);
    }

    static {
        filter.add((Predicate)SubType.FOREST.getPredicate());
    }
}

