/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class LlawanCephalidRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterCard filter = new FilterCard("blue creature spells");

    public LlawanCephalidRuleModifyingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast blue creature spells";
    }

    private LlawanCephalidRuleModifyingEffect(LlawanCephalidRuleModifyingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public LlawanCephalidRuleModifyingEffect copy() {
        return new LlawanCephalidRuleModifyingEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast blue creature spells (" + mageObject.getLogName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && game.isOpponent(controller, event.getPlayerId())) {
            Card card = game.getCard(event.getSourceId());
            return card != null && filter.match(card, source.getControllerId(), source, game);
        }
        return false;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

