/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetDiscard;

class LoamcrafterFaunDiscardEffect
extends OneShotEffect {
    private static FilterCard filter = new FilterPermanentCard("nonland permanent cards in your graveyard");

    LoamcrafterFaunDiscardEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may discard one or more land cards. When you do, return up to that many target nonland permanent cards from your graveyard to your hand.";
    }

    private LoamcrafterFaunDiscardEffect(LoamcrafterFaunDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public LoamcrafterFaunDiscardEffect copy() {
        return new LoamcrafterFaunDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetDiscard target = new TargetDiscard(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS, player.getId());
        player.choose(Outcome.Discard, (Target)target, source, game);
        Cards cards = player.discard((Cards)new CardsImpl((Collection)target.getTargets()), false, source, game);
        if (cards.isEmpty()) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToHandTargetEffect(), false);
        ability.addTarget((Target)new TargetCardInYourGraveyard(0, cards.size(), filter, false));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

