/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LobeLobberEffect
extends OneShotEffect {
    LobeLobberEffect() {
        super(Outcome.Benefit);
        this.staticText = "Roll a six-sided die. On a 5 or higher, untap it";
    }

    private LobeLobberEffect(LobeLobberEffect effect) {
        super((OneShotEffect)effect);
    }

    public LobeLobberEffect copy() {
        return new LobeLobberEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amount = controller.rollDice(this.outcome, source, game, 6);
            if (amount >= 5) {
                new UntapSourceEffect().apply(game, source);
            }
            return true;
        }
        return false;
    }
}

