/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AddCounterNextSpellDelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.LongListOfTheEnts;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterSpell;
import mage.filter.common.FilterCreatureSpell;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class LongListOfTheEntsEffect
extends OneShotEffect {
    LongListOfTheEntsEffect() {
        super(Outcome.Benefit);
        this.staticText = "note a creature type that hasn't been noted for {this}. When you next cast a creature spell of that type this turn, that creature enters the battlefield with an additional +1/+1 counter on it.";
    }

    private LongListOfTheEntsEffect(LongListOfTheEntsEffect effect) {
        super((OneShotEffect)effect);
    }

    public LongListOfTheEntsEffect copy() {
        return new LongListOfTheEntsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        LinkedHashSet<SubType> newEntList;
        int offset;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Object existingEntList = game.getState().getValue(LongListOfTheEnts.getKey(game, source, 0));
        if (existingEntList == null) {
            offset = 1;
            newEntList = new LinkedHashSet<SubType>();
        } else {
            offset = 0;
            newEntList = new LinkedHashSet((Set)existingEntList);
        }
        Set chosenTypes = newEntList.stream().map(SubType::toString).collect(Collectors.toSet());
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        choice.getKeyChoices().keySet().removeIf(chosenTypes::contains);
        if (!player.choose(Outcome.BoostCreature, (Choice)choice, game)) {
            return false;
        }
        SubType subType = SubType.byDescription((String)choice.getChoiceKey());
        game.informPlayers(player.getLogName() + " notes the creature type " + subType);
        newEntList.add(subType);
        game.getState().setValue(LongListOfTheEnts.getKey(game, source, offset), newEntList);
        FilterCreatureSpell filter = new FilterCreatureSpell("a creature spell of that type");
        filter.add((Predicate)subType.getPredicate());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AddCounterNextSpellDelayedTriggeredAbility((FilterSpell)filter), source);
        return true;
    }
}

