/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class LongTermPlansEffect
extends OneShotEffect {
    LongTermPlansEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a card, then shuffle and put that card third from the top";
    }

    private LongTermPlansEffect(LongTermPlansEffect effect) {
        super((OneShotEffect)effect);
    }

    public LongTermPlansEffect copy() {
        return new LongTermPlansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        player.shuffleLibrary(source, game);
        if (card != null) {
            player.putCardOnTopXOfLibrary(card, game, source, 3, false);
        }
        return true;
    }
}

