/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class LonisCryptozoologistEffect
extends OneShotEffect {
    LonisCryptozoologistEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Target opponent reveals the top X cards of their library. You may put a nonland permanent card with mana value X or less from among them onto the battlefield under your control. That player puts the rest on the bottom of their library in a random order";
    }

    private LonisCryptozoologistEffect(LonisCryptozoologistEffect effect) {
        super((OneShotEffect)effect);
    }

    public LonisCryptozoologistEffect copy() {
        return new LonisCryptozoologistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && opponent != null) {
            int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
            CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, xValue));
            opponent.revealCards(source, (Cards)cards, game);
            if (controller.chooseUse(this.outcome, "Put a nonland permanent card with mana value " + xValue + " or less from among revealed cards onto the battlefield under your control?", source, game)) {
                Card selectedCard;
                FilterPermanentCard filter = new FilterPermanentCard("nonland permanent card with mana value " + xValue + " or less");
                filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
                TargetCard target = new TargetCard(Zone.LIBRARY, (FilterCard)filter);
                if (controller.choose(this.outcome, (Cards)cards, target, source, game) && (selectedCard = game.getCard(target.getFirstTarget())) != null) {
                    cards.remove(selectedCard);
                    controller.moveCards(selectedCard, Zone.BATTLEFIELD, source, game);
                }
            }
            opponent.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            return true;
        }
        return false;
    }
}

